#include <pwm.h>
#include <p30fxxxx.h>

/* PWM1-3 are defined in following devices */
#if defined(__dsPIC30F2010__) || defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || \
    defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5015__)

/*********************************************************************
* Function Name     : SetDCMCPWM
* Description       : This function updates the dutycycle register and 
*                     updatedisable bit.
* Parameters        : unsigned int dutycyclereg for selection of reg
*                      (ie PDC1, PDC2...)
*                     unsigned int dutycycle
*                     char updatedisable
* Return Value      : None 
**********************************************************************/

void SetDCMCPWM(unsigned int dutycyclereg, unsigned int dutycycle,
                char updatedisable)
{
    PWMCON2bits.UDIS = updatedisable & 0x1;
    
    /* Assign dutycycle to the duty cycle register */
    *(&PDC1+dutycyclereg -1) = dutycycle; 
}

#endif
